﻿using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
    public class EFR_VIEW_LOOKUPDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public EFR_VIEW_LOOKUPDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public List<EFR_VIEW_LOOKUP> GetItems(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            List<EFR_VIEW_LOOKUP> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_EFR_VIEW_LOOKUP_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
